---
title: Rate limiting rule examples · Cloudflare Web Application Firewall (WAF) docs
description: The examples below include sample rate limiting rule configurations.
lastUpdated: 2025-09-12T15:50:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/rate-limiting-rules/use-cases/
  md: https://developers.cloudflare.com/waf/rate-limiting-rules/use-cases/index.md
---

The examples below include sample rate limiting rule configurations.

## Example 1

The following [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/) performs rate limiting on incoming requests from the US addressed at the login page, except for one allowed IP address.

Expression:\
`(http.request.uri.path eq "/login" and ip.src.country eq "US" and ip.src ne 192.0.0.1)`

Rule characteristics:

* *Data center ID* (included by default when creating the rule in the dashboard)
* *IP Address*

## Example 2

The following [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/) performs rate limiting on incoming requests with a given base URI path, incrementing on the IP address and the provided API key.

Expression:\
`(http.request.uri.path contains "/product" and http.request.method eq "POST")`

Rule characteristics:

* *Data center ID* (included by default when creating the rule in the dashboard)
* *IP Address*
* *Header value of* > `x-api-key`

## Example 3

The following [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/) performs rate limiting on requests targeting multiple URI paths in two hosts, excluding known bots. The request rate is based on IP address and `User-Agent` values.

Expression:\
`(http.request.uri.path eq "/store" or http.request.uri.path eq "/prices") and (http.host eq "mystore1.com" or http.host eq "mystore2.com") and not cf.client.bot`

Rule characteristics:

* *Data center ID* (included by default when creating the rule in the dashboard)
* *IP Address*
* *Header value of* > `user-agent`

## Example 4

Note

[Complexity-based rate limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/#complexity-based-rate-limiting) is only available to Enterprise customers with Advanced Rate Limiting.

The following [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/) performs complexity-based rate limiting. The rule takes into account the `my-score` HTTP response header provided by the origin server to calculate a total complexity score for the client with the provided API key.

The counter with the total score is updated when there is a match for the rate limiting rule's [counting expression](https://developers.cloudflare.com/waf/rate-limiting-rules/parameters/#increment-counter-when) (in this case, the same as the rule expression since a counting expression was not provided). When this total score becomes larger than `400` during a period of one minute, any later client requests will be blocked for a period of 10 minutes.

Expression:\
`(http.request.uri.path wildcard "/graphql/*")`

Rule characteristics:

* *Data center ID* (included by default when creating the rule in the dashboard)
* *Header value of* > `x-api-key`

When rate exceeds: **Complexity based**

* Score per period: `400`
* Period: *1 minute*
* Response header name: `my-score`

Then take action:

* Choose action: *Block*

With the following behavior: **Block for the selected duration**

* Duration: *10 minutes*

For an API example with this rule configuration, refer to [Create a rate limiting rule via API](https://developers.cloudflare.com/waf/rate-limiting-rules/create-api/#example-d---complexity-based-rate-limiting-rule).
